@extends('layouts.admin.app')

@section('title', \App\CentralLogics\translate('Review List'))

@push('css_or_js')

@endpush

@section('content')
    <div class="content container-fluid">
        <!-- Page Header -->
        <div class="page-header">
            <div class="row align-items-center">
                <div class="col-sm mb-2 mb-sm-0">
                    <h1 class="page-header-title">{{\App\CentralLogics\translate('review')}} {{\App\CentralLogics\translate('list')}}</h1>
                </div>
            </div>
        </div>
        <!-- End Page Header -->
        <div class="row gx-2 gx-lg-3">
            <div class="col-sm-12 col-lg-12 mb-3 mb-lg-2">
                <!-- Card -->
                <div class="card">
                    <!-- Header -->
                    <div class="card-header">
                        <div class="flex-start">
                            <h5 class="card-header-title">{{\App\CentralLogics\translate('Delivery Men Review Table')}}</h5>
                            <h5 class="card-header-title text-primary mx-1">({{ $reviews->total() }})</h5>
                        </div>
                    </div>
                    <!-- End Header -->

                    <!-- Table -->
                    <div class="table-responsive datatable-custom">
                        <table id="columnSearchDatatable"
                               class="table table-borderless table-thead-bordered table-nowrap table-align-middle card-table"
                               data-hs-datatables-options='{
                                 "order": [],
                                 "orderCellsTop": true
                               }'>
                            <thead class="thead-light">
                            <tr>
                                <th>{{\App\CentralLogics\translate('#')}}</th>
                                <th style="width: 30%">{{\App\CentralLogics\translate('deliveryman')}}</th>
                                <th style="width: 25%">{{\App\CentralLogics\translate('customer')}}</th>
                                <th>{{\App\CentralLogics\translate('review')}}</th>
                                <th>{{\App\CentralLogics\translate('rating')}}</th>
                            </tr>
                            <tr>
                                <th></th>
                                <th>
                                    {{--<input type="text" id="column1_search" class="form-control form-control-sm"
                                           placeholder="Search">--}}

                                    <form action="{{url()->current()}}" method="GET">
                                        <!-- Search -->
                                        <div class="input-group input-group-merge input-group-flush">
                                            <div class="input-group-prepend">
                                                <div class="input-group-text">
                                                    <i class="tio-search"></i>
                                                </div>
                                            </div>
                                            <input id="datatableSearch_" type="search" name="search"
                                                   class="form-control"
                                                   placeholder="Search" aria-label="Search" value="{{$search}}"
                                                   required>
                                            <button type="submit" class="btn btn-primary">search</button>

                                        </div>
                                        <!-- End Search -->
                                    </form>
                                </th>
                                <th></th>
                                <th></th>
                                <th></th>
                            </tr>
                            </thead>

                            <tbody>
                            @foreach($reviews as $key=>$review)

                                <tr>
                                    <td>{{$reviews->firstitem()+$key}}</td>
                                    <td>
                                        @if(isset($review->delivery_man))
                                            <span class="d-block font-size-sm text-body">
                                                <a href="{{route('admin.delivery-man.preview',[$review['delivery_man_id']])}}">
                                                    {{$review->delivery_man->f_name.' '.$review->delivery_man->l_name}}
                                                </a>
                                            </span>
                                        @else
                                            <span class="badge-pill badge-soft-dark text-muted text-sm small">
                                                    {{\App\CentralLogics\translate('Deliveryman unavailable')}}
                                                </span>
                                        @endif
                                    </td>
                                    <td>
                                        @if(isset($review->customer))
                                            <span class="d-block font-size-sm text-body">
                                                    <a href="{{route('admin.customer.view',[$review->user_id])}}">
                                                        {{$review->customer->f_name." ".$review->customer->l_name}}
                                                    </a>
                                                </span>
                                        @else
                                            <span class="badge-pill badge-soft-dark text-muted text-sm small">
                                                    {{\App\CentralLogics\translate('Customer unavailable')}}
                                                </span>
                                        @endif
                                    </td>
                                    <td>
                                        {{$review->comment??''}}
                                    </td>
                                    <td>
                                        <label class="badge badge-soft-info">
                                            {{$review->rating??0}} <i class="tio-star"></i>
                                        </label>
                                    </td>
                                </tr>

                            @endforeach
                            </tbody>
                        </table>
                        <hr>
                        <table>
                            <tfoot>
                            {!! $reviews->links() !!}
                            </tfoot>
                        </table>
                    </div>
                    <!-- End Table -->
                </div>
                <!-- End Card -->
            </div>
        </div>
    </div>

@endsection

@push('script_2')
    <script>
        $(document).on('ready', function () {
            // INITIALIZATION OF DATATABLES
            // =======================================================
            var datatable = $.HSCore.components.HSDatatables.init($('#columnSearchDatatable'));

            $('#column1_search').on('keyup', function () {
                datatable
                    .columns(1)
                    .search(this.value)
                    .draw();
            });

            $('#column2_search').on('keyup', function () {
                datatable
                    .columns(2)
                    .search(this.value)
                    .draw();
            });

            $('#column3_search').on('change', function () {
                datatable
                    .columns(3)
                    .search(this.value)
                    .draw();
            });

            $('#column4_search').on('keyup', function () {
                datatable
                    .columns(4)
                    .search(this.value)
                    .draw();
            });


            // INITIALIZATION OF SELECT2
            // =======================================================
            $('.js-select2-custom').each(function () {
                var select2 = $.HSCore.components.HSSelect2.init($(this));
            });
        });
    </script>
@endpush
